
# OpenAI Gym

## Download datasets

Datasets are stored in the `data-gym` directory.
Install the [D4RL repo](https://github.com/rail-berkeley/d4rl), following the instructions there.
Then, run the following script in order to download the datasets and save them in our format:

```
python data-gym/download_d4rl_datasets.py
```

## Installation

Please install dependent packages using the following command:

```
docker build -f Dockerfile -t radt_gym .

docker run --gpus all \
    --rm -it --name radt_$(($RANDOM % 1000 + 1000)) \
    --shm-size=30g \
    --memory=30g \
    -e HOSTNAME=$HOSTNAME \
    -v ./data-gym:/radt_gym/data-gym \
    -v ./logs:/radt_gym/logs \
    radt_gym bash
```

## Example usage

Experiments can be reproduced with the following in your Docker container:

```
./scripts/run.sh ant medium-replay
```
