# Joint Multidimensional Scaling

## Installation

The dependencies are managed by [miniconda][1]

```
python=3.9
numpy
scipy
pytorch=1.9.1
scikit-learn
pandas
```

## Reproduction of results in the paper

#### Joint visualization and unsupervised heterogeneous domain adaptation

First, download datasets from [Demetci et al. 2020][2] and place them to the `datasets` directory.

For sythetic datasets, run

```bash
python example_simulation.py --dataset s1 --components 2
```
The dataset can be either `s1`, `s2` or `s3` respectively for bifurcation, Swiss roll and circular frustum.

For real-world datasets, run

```bash
# scGEM
python example_scGEM.py --components 2

# SNAREseq
python example_SNAREseq.py --components 2

# MNIST-USPS
python example_mnist_usps.py --components 2
```

#### Graph matching
For PPI network matching, the target graph has 5%, 15% or 25% additonal noisy edges. For example, for matching 5% noise graph, run
```bash
python test_matching_PPI.py --noise 5
```

For MIMIC graph matching task, run
```bash
python test_matching_MIMIC.py
```


#### Protein structure alignment

First unzip the protein models from `datasets/CASP14.zip` via `cd datasets; unzip CASP14.zip`. Then, run

```bash
python test_protein_alignment.py
```


[1]: https://conda.io/miniconda.html
[2]: https://github.com/rsinghlab/SCOT
