# FENN
from parameter_set.TPP.fenn_parameter_set import training_hyperparameter as feps_t
from parameter_set.TPP.fenn_parameter_set import plot_hyperparameter as feps_p

# FullyNN 
from parameter_set.TPP.fullynn_parameter_set import training_hyperparameter as fps_t
from parameter_set.TPP.fullynn_parameter_set import plot_hyperparameter as fps_p

# Transformer Hawkes Process(THP)
from parameter_set.TPP.thp_parameter_set import training_hyperparameter as thp_t
from parameter_set.TPP.thp_parameter_set import plot_hyperparameter as thp_p

# Self-attentive Hawkes Process(SAHP)
from parameter_set.TPP.sahp_parameter_set import training_hyperparameter as sahp_t
from parameter_set.TPP.sahp_parameter_set import plot_hyperparameter as sahp_p

# Intensity-free NMTPP
from parameter_set.TPP.ifn_parameter_set import training_hyperparameter as ifcps_t
from parameter_set.TPP.ifn_parameter_set import plot_hyperparameter as ifcps_p

# Marked_LogNormMix
from parameter_set.TPP.marked_lognormmix_parameter_set import training_hyperparameter as mifl_t
from parameter_set.TPP.marked_lognormmix_parameter_set import plot_hyperparameter as mifl_p

plot_parameter_set = {
    'fenn': {'train': feps_t, 'plot': feps_p},
    'fullynn': {'train': fps_t, 'plot': fps_p},
    'thp': {'train': thp_t, 'plot': thp_p},
    'sahp': {'train': sahp_t, 'plot': sahp_p},
    'ifn': {'train': ifcps_t, 'plot': ifcps_p},
    'marked_lognormmix': {'train': mifl_t, 'evaluate': mifl_p},
}

def parameter_retriver(opt):
    model_parameter_set = plot_parameter_set[opt.model]
    required_parameter_set = model_parameter_set[opt.script_type][opt.dataset]
    
    return required_parameter_set
    