import os
import numpy as np
import pickle as pkl

root_path = os.path.dirname(os.path.abspath(__file__))

datasets = ['bookorder', 'taobao', 'retweet', 'stackoverflow', 'usearthquake', 'yelp']
# datasets = ['usearthquake']
retries = ['1', '2', '3']

dict_num_marks = {
    'bookorder': 2,
    'retweet': 3,
    'stackoverflow': 22,
    'taobao': 17,
    'usearthquake': 7,
    'yelp': 3
}

freq_marks = {
    'bookorder': [0],
    'retweet': [0, 1],
    'stackoverflow': [0, 3, 4, 5, 8, ],
    'taobao': [16, ],
    'usearthquake': [0, 1, 2],
    'yelp': [1, ]
}

rare_marks = {
    'bookorder': [1, ],
    'retweet': [2, ],
    'stackoverflow': [1, 2, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21],
    'taobao': list(range(16)),
    'usearthquake': [3, 4, 5, 6],
    'yelp': [0, 2]
}

for selected_dataset in datasets:
    results_freq = []
    results_rare = []
    dataset_size_for_each_mark = None

    for retry_idx in retries:
        mae_e_data_location = os.path.join(root_path, 'mae_e_by_time_event', \
                                           retry_idx, f'test_mae_e_by_time_event_{selected_dataset}.pkl')
        f_data = open(mae_e_data_location, 'rb')
        data = pkl.load(f_data)
        f_data.close()
        
        mae_e_rare = []
        mae_e_frequent = []

        for mae_e_per_seq, event_next_per_seq in zip(data['mae_e'], data['event_next']):
            for each_mae_e, each_next_event in zip(mae_e_per_seq, event_next_per_seq):
                if each_next_event in freq_marks[selected_dataset]:
                    mae_e_frequent.append(each_mae_e)
                elif each_next_event in rare_marks[selected_dataset]:
                    mae_e_rare.append(each_mae_e)
        
        if len(mae_e_rare) > 0:
            q123_rare = np.percentile(mae_e_rare, [25, 50, 75])
        else:
            q123_rare = None
        
        if len(mae_e_frequent) > 0:
            q123_frequent = np.percentile(mae_e_frequent, [25, 50, 75])
        else:
            q123_frequent = None

        if q123_frequent is not None:
            results_freq.append(q123_frequent)
        if q123_rare is not None:
            results_rare.append(q123_rare)
        del data

    text = os.path.join(root_path, 'mae_e_by_time_event', f'{selected_dataset}_mae_e_freq_rare.txt')
    f_text = open(text, 'w')
    f_text.write(f'Dataset {selected_dataset} has {dict_num_marks[selected_dataset]} marks.\n')
    
    if len(results_freq) > 0:
        tmp_sub_mae_e_list = np.array(results_freq)
        mean = tmp_sub_mae_e_list.mean(axis = 0)
        std = tmp_sub_mae_e_list.std(axis = 0)
        f_text.write(f'For frequent marks.\n')
        f_text.write('Q1: {0}±{3}, Q2: {1}±{4}, Q3: {2}±{5}. \n'.format(*mean, *std))

    if len(results_rare) > 0:
        tmp_sub_mae_e_list = np.array(results_rare)
        mean = tmp_sub_mae_e_list.mean(axis = 0)
        std = tmp_sub_mae_e_list.std(axis = 0)
        f_text.write(f'For rare marks.\n')
        f_text.write('Q1: {0}±{3}, Q2: {1}±{4}, Q3: {2}±{5}. \n'.format(*mean, *std))

    f_text.close()