import matplotlib.pyplot as plt
import numpy as np
import pickle as pkl
import seaborn as sns
import pandas as pd
import os

# parameters
history_length_ratio = 0.4
dataset = 'taobao'
event_type = 17
number_of_attempts = 10

# load data
df_all_sampled_events = []
for attempt_idx in range(number_of_attempts):
    f_data = open(os.path.join(dataset, f'time-event_{dataset}_{history_length_ratio}_{attempt_idx}.pkl'), 'rb')
    info = pkl.load(f_data)
    f_data.close()
    # info = {'event_history': events_history_for_sample, 'time_history': time_history_for_sample, 'sampled_time': sampled_times}
    event_history = info['event_history'].squeeze()
    time_history = info['time_history'].squeeze()
    sampled_time = info['sampled_time'].squeeze()
    sampled_events = info['sampled_mark'].squeeze()
    
    dict_sampled_events = {
        'Event Types': [f'{idx}' for idx in range(event_type)],
        'The number of samples': [0,] * event_type
    }
    
    found_events, event_counts = np.unique(sampled_events, return_counts = True)
    for found_event, event_count in zip(found_events, event_counts):
        dict_sampled_events['The number of samples'][found_event] = event_count

    df_all_sampled_events.append(pd.DataFrame.from_dict(dict_sampled_events))

df_all_sampled_events = pd.concat(df_all_sampled_events, ignore_index = True)

plt.rcParams.update({'font.size': 22, 'figure.figsize': (12, 8)})
fig = plt.figure()
sns.barplot(x = 'Event Types', y = 'The number of samples', data = df_all_sampled_events, palette = 'pastel')
plt.savefig(os.path.join(dataset, f'time_event_{dataset}_{history_length_ratio}.png'), dpi = 1000)