# parameter sets of model lognormmix

realworld_training_hyperparameter_list = {
    "file_name": "start.py",
    "single": [
        "--no_seed",
        "--dataloader_name", "lognormmix",
        "--model_name", "marked_lognormmix",
        "--lr", "0.002",
        "--save_mode", "best",
        "--lr_sched",
        "--op_name", "AdamW",
        "--optim_config", "optimizer.yml",
        "--n_cycles", "0.5",
        # "--wandb"
    ],
    'index':
    {
        'multiple':[
            "--dataset_name", ["stackoverflow", "retweet", "bookorder", "taobao", "usearthquake", "yelp"],
            "--dataloader_config", ["stackoverflow/lognormmix_dl.yml", "retweet/lognormmix_dl.yml", \
                                    "bookorder/lognormmix_dl.yml", "taobao/lognormmix_dl.yml", \
                                    "usearthquake/lognormmix_dl.yml", "yelp/lognormmix_dl.yml"],
            "--model_config", ["stackoverflow/lognormmix.yml", "retweet/lognormmix.yml", \
                               "bookorder/lognormmix.yml", "taobao/lognormmix.yml", \
                               "usearthquake/lognormmix.yml", "yelp/lognormmix.yml"],
            "--n_training_steps", ["200000", "400000", "20000", "80000", "200000", "200000"],
            "--n_evaluation_steps", ["2000", "4000", "500", "800", "2000", "2000"],
            "--n_report_steps", ["2000", "4000", "4000", "800", "2000", "2000"],
            "-tb", ["32", "32", "8", "32", "32", "32"],
            "-eb", ["32", "32", "8", "32", "32", "32"],
            "--n_warmup_steps", ["40000", "80000", "4000", "16000", "40000", "40000"],
        ]
    }
}

syn_training_hyperparameter_list = {
    "file_name": "start.py",
    "single": [
        "--no_seed",
        "--dataloader_name", "lognormmix",
        "--n_training_steps", "100000",
        "--n_evaluation_steps", "2000",
        "--n_report_steps", "2000",
        "-tb", "32",
        "-eb", "128",
        "--n_warmup_steps", "20000",
        "--model_name", "marked_lognormmix",
        "--lr", "0.002",
        "--save_mode", "best",
        "--lr_sched",
        "--op_name", "AdamW",
        "--optim_config", "optimizer.yml",
        "--model_config", "syn/lognormmix.yml",
        "--n_cycles", "0.5",
        # "--wandb"
    ],
    "index":{
        'multiple':[
            "--dataset_name", ["hawkes_1_v2", "hawkes_2_v2", "poisson_v2", "self_correct_v2", "stationary_renewal_v2"],
        ]
    }
}

realworld_plot_hyperparameter_list = {
    "file_name": "start.py",
    "single": [
        "--seed", "32",
        "--model_name", "marked_lognormmix",
        "--lr", "0.002",
        "--dataloader_name", "lognormmix",
        "--figure_count", "1",
        # "--train",
        # "--evaluation",
        "--test",
        "--used_dataloader_config", "lognormmix_dl.yml",
        "--resolution", "200",
        "--combine_used_and_current_dataloader_config",
    ],
    'index': {
        'multiple':[
            "--used_dataloader_config", ["stackoverflow/lognormmix_dl.yml", "retweet/lognormmix_dl.yml", \
                                         "bookorder/lognormmix_dl.yml", "taobao/lognormmix_dl.yml", \
                                         "usearthquake/lognormmix_dl.yml", "yelp/lognormmix_dl.yml"],
            "--dataset_name", ["stackoverflow", "retweet", "bookorder", "taobao", "usearthquake", "yelp"],
            "--model_config", ["stackoverflow/lognormmix.yml", "retweet/lognormmix.yml", "bookorder/lognormmix.yml", \
                               "taobao/lognormmix.yml", "usearthquake/lognormmix.yml", "yelp/lognormmix.yml"],
            "--n_training_steps", ["200000", "400000", "20000", "80000", "200000", "200000"],
            "--dataloader_config", ["stackoverflow/lognormmix_dl_plot.yml", "retweet/lognormmix_dl_plot.yml", \
                                    "bookorder/lognormmix_dl_plot.yml", "taobao/lognormmix_dl_plot.yml", \
                                    "usearthquake/lognormmix_dl_plot.yml", "yelp/lognormmix_dl_plot.yml"],
            "--used_batch_size", ["32", "32", "8", "32", "32", "32"],
        ]
    },
    "counting": {
        'index':{
            'multiple':[
                "--plot_type", ["intensity", "probability", "debug", "debug", "debug"],
                "--task_name", ['graph', 'graph', 'graph', 'mae_and_f1', 'mae_e_and_f1']
                # "--plot_type", ["debug",],
                # "--task_name", ['get_nll',]
            ]
        }
    }
}

syn_plot_hyperparameter_list = {
    "file_name": "start.py",
    "single": [
        "--seed", "32",
        "--model_name", "marked_lognormmix",
        "--lr", "0.002",
        "--dataloader_name", "lognormmix",
        "--figure_count", "1",
        "--n_training_steps", "100000",
        # "--train",
        # "--evaluation",
        "--test",
        "--resolution", "200",
        "--used_batch_size", "32",
        "--dataloader_config", "syn/lognormmix_dl_plot.yml",
        "--model_config", "syn/lognormmix.yml",
    ],
    'index': {
        'multiple':[
            "--dataset_name", ["hawkes_1_v2", "hawkes_2_v2", "poisson_v2", "self_correct_v2", "stationary_renewal_v2"],
        ]
    },
    "counting": {
        'index':{
            "multiple":[
                "--plot_type", ["intensity", "probability", "debug", "debug"],
                "--task_name", ['graph', 'graph', 'graph', 'spearman_and_l1']
            ]
        }
    }
}

training_hyperparameter = {
    'real': realworld_training_hyperparameter_list,
    'syn': syn_training_hyperparameter_list
}

plot_hyperparameter = {
    'real': realworld_plot_hyperparameter_list,
    'syn': syn_plot_hyperparameter_list
}