import os
import numpy as np
import pickle as pkl


root_path = os.path.dirname(os.path.abspath(__file__))

datasets = ['stackoverflow', 'bookorder', 'taobao', \
            'retweet', 'usearthquake', 'yelp']

dict_num_marks = {
    'bookorder': 2,
    'retweet': 3,
    'stackoverflow': 22,
    'taobao': 17,
    'usearthquake': 7,
    'yelp': 3
}

freq_marks = {
    'bookorder': [0],
    'retweet': [0, 1],
    'stackoverflow': [0, 3, 4, 5, 8, ],
    'taobao': [16, ],
    'usearthquake': [0, 1, 2],
    'yelp': [1, ]
}

rare_marks = {
    'bookorder': [1],
    'retweet': [2, ],
    'stackoverflow': [1, 2, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21],
    'taobao': list(range(16)),
    'usearthquake': [3, 4, 5, 6],
    'yelp': [0, 2]
}

retries = ['1', '2', '3']


for selected_dataset in datasets:
    count_marks = True
    results = {idx: [] for idx in range(dict_num_marks[selected_dataset])}
    dataset_size_for_each_mark = None

    for retry_idx in retries:
        if count_marks:
            dataset_size_for_each_mark = [0 for _ in range(dict_num_marks[selected_dataset])]

        mae_e_data_location = os.path.join(root_path, 'mae_e_by_time_event', \
                                           retry_idx, f'test_mae_e_by_time_event_{selected_dataset}.pkl')
        f_data = open(mae_e_data_location, 'rb')
        data = pkl.load(f_data)
        f_data.close()
        
        mae_e_split_by_marks = [[] for _ in range(dict_num_marks[selected_dataset])]
        for mae_e_per_seq, event_next_per_seq in zip(data['mae_e'], data['event_next']):
            for each_mae_e, each_next_event in zip(mae_e_per_seq, event_next_per_seq):
                mae_e_split_by_marks[each_next_event].append(each_mae_e)
                if count_marks:
                    dataset_size_for_each_mark[each_next_event] += 1
                    
        for mark, each_mae_e in enumerate(mae_e_split_by_marks):
            values = [*np.percentile(each_mae_e, [25, 50, 75]), np.mean(each_mae_e)]
            results[mark].append(values)
        
        del data
        count_marks = False

    # Here we calculate the geometric mean and its standard variance.
    freq_results = []
    rare_results = []
    for freq_mark in freq_marks[selected_dataset]:
        freq_results.append(results[freq_mark])
    for rare_mark in rare_marks[selected_dataset]:
        rare_results.append(results[rare_mark])

    text = os.path.join(root_path, 'mae_e_by_time_event', f'{selected_dataset}_mae_e_by_marks_macro.txt')
    f_text = open(text, 'w')
    f_text.write(f'Dataset {selected_dataset} has {dict_num_marks[selected_dataset]} marks.\n')

    if len(freq_results) > 0:
        log_geometry = np.log(freq_results).sum(axis = 0) / len(freq_results)
        geometry_mean_freq = np.exp(log_geometry)
        mean_geometry_mean_freq = geometry_mean_freq.mean(axis = 0)
        std_geometry_mean_freq = geometry_mean_freq.std(axis = 0)
        f_text.write(f'For frequent marks:\n')
        f_text.write('Q1: {0}±{4}, Q2: {1}±{5}, Q3: {2}±{6}, mean: {3}±{7}. \n'.format(*mean_geometry_mean_freq, *std_geometry_mean_freq))

    if len(rare_results) > 0:
        log_geometry = np.log(rare_results).sum(axis = 0) / len(rare_results)
        geometry_mean_rare = np.exp(log_geometry)
        mean_geometry_mean_rare = geometry_mean_rare.mean(axis = 0)
        std_geometry_mean_rare = geometry_mean_rare.std(axis = 0)
        f_text.write(f'For rare marks:\n')
        f_text.write('Q1: {0}±{4}, Q2: {1}±{5}, Q3: {2}±{6}, mean: {3}±{7}. \n'.format(*mean_geometry_mean_rare, *std_geometry_mean_rare))

    f_text.close()