from PIL import Image
import numpy as np
import cv2
from matplotlib import pyplot as plt
import torch

def make_masktensor(width,height,sticker,x,y):
    layer = Image.new('RGBA',(width,height),(255,255,255,0))
    layer.paste(sticker,(x,y))
    base = np.array(layer)
    alpha_matrix = base[:,:,3]
    basemap = np.where(alpha_matrix!=0,1,0)
    rep = cv2.merge((basemap,basemap,basemap))
    rep = torch.from_numpy(rep)
    rep = torch.unsqueeze(rep,0)
    return rep

def make_basemap(width,height,sticker,x,y):
    layer = Image.new('RGBA',(width,height),(255,255,255,0))
    layer.paste(sticker,(x,y))
    #layer.show()
    base = np.array(layer)
    alpha_matrix = base[:,:,3]
    basemap = np.where(alpha_matrix!=0,1,0)
    return base,basemap
