import os
import json
import random

from .smiles_tokenization import tokenize_smiles


def sample_tokenizer_1(sample):
    task = sample['task']
    sample_input, sample_output = sample['input'], sample['output']
    if task in ('forward_prediction', 'retrosynthesis'):
        sample_input = ''.join(tokenize_smiles(sample_input))
        sample_output = ''.join(tokenize_smiles(sample_output))
    elif task in ('molecule_description', 'name_conversion-s2f', 'name_conversion-s2i'):
        sample_input = ''.join(tokenize_smiles(sample_input))
    elif task in ('molecule_design', 'name_conversion-i2s',):
        sample_output = ''.join(tokenize_smiles(sample_output))
    return sample_input, sample_output


class ChatConstructor(object):
    
    def generate_io_text(self, sample, sample_tokenizer=None, text_before_instruction=None):
        raise NotImplementedError('Not examined for this version. Use after revising.')
        task = sample['task']
        if self.random_template:
            template_id = random.randint(0, len(self.tasks_templates[task]) - 1)
        else:
            template_id = sample['template_id']
        template = self.tasks_templates[task][template_id]
        if sample_tokenizer is None:
            sample_input = sample['input']
            sample_output = sample['output']
        else:
            sample_input, sample_output = sample_tokenizer(sample)
        instruction_text = template['Instruction'].replace('<INPUT>', sample_input)
        if text_before_instruction is not None:
            instruction_text = text_before_instruction + instruction_text
        answer_text = template['Answer'].replace('<OUTPUT>', sample_output)
        return instruction_text, answer_text, template_id

    def generate_chat(self, input_text, output_text=None, prefix_chat=None):
        chat = [
            {"role": "user", "content": input_text},
        ]
        if output_text is not None:
            chat.append({"role": "assistant", "content": output_text})
        if prefix_chat is not None:
            chat = prefix_chat + chat
        return chat
