def make_smiles_tokens_special(tokens):
    tokens = ['【%s】' % token for token in tokens]
    return tokens


# From Molecular Transformer: https://github.com/pschwllr/MolecularTransformer
def tokenize_smiles(smi, use_special_tokens=True):
    """
    Tokenize a SMILES molecule or reaction
    """
    import re
    pattern =  "(\[[^\]]+]|Br?|Cl?|N|O|S|P|F|I|b|c|n|o|s|p|\(|\)|;|\.|=|#|-|\+|\\\\|\/|:|~|@|\?|>|\*|\$|\%[0-9]{2}|[0-9])"
    regex = re.compile(pattern)
    tokens = [token for token in regex.findall(smi)]
    assert smi == ''.join(tokens), 'before: %s\nafter: %s' % (smi, ''.join(tokens))
    if use_special_tokens:
        tokens = make_smiles_tokens_special(tokens)
    return tokens