import json
import pickle

from tqdm import tqdm
from openai import OpenAI
import concurrent.futures


def get_embedding(client, text):
    response = client.embeddings.create(
        input=text,
        model="text-embedding-3-large"
    )
    return {text: response.data[0].embedding}


if __name__ == "__main__":
    reviews = []
    with open("children/raw/goodreads_reviews_children.json") as f:
        for line in f:
            data = json.loads(line)
            reviews.append(data['review_text'])

    results = []

    with concurrent.futures.ThreadPoolExecutor() as executor:
        with OpenAI(api_key='') as client:  # TODO: fill in your api_key
            futures = [executor.submit(get_embedding, client, text) for text in reviews]

            for future in tqdm(concurrent.futures.as_completed(futures)):
                results.append(future.result())

    with open("embeddings.pkl", "wb") as f:
        pickle.dump(results, f)

    print(results)
