import json
import pickle

from tqdm import tqdm
from openai import OpenAI
import concurrent.futures


def get_embedding(client, user_book, text):
    response = client.embeddings.create(
        input=text,
        model="text-embedding-3-large"
    )
    return {user_book: response.data[0].embedding}


if __name__ == "__main__":
    with open('0.15_train_text', 'rb') as f:
        loaded_data = pickle.load(f)

    results = {}

    with concurrent.futures.ThreadPoolExecutor() as executor:
        with OpenAI(api_key='') as client:  # TODO: fill in openAI api_key
            futures = [executor.submit(get_embedding, client, user_book, text) for user_book, text in
                       loaded_data.items()]

            for future in tqdm(concurrent.futures.as_completed(futures)):
                result = future.result()
                results.update(result)  # 将结果添加到结果字典中

    with open("embeddings.pkl", "wb") as f:
        pickle.dump(results, f)

    print(results)
