#!/bin/bash
# Set the value of ITK_GLOBAL_DEFAULT_NUMBER_OF_THREADS to 8
export ITK_GLOBAL_DEFAULT_NUMBER_OF_THREADS=8
# Initialize a counter for parallel jobs
parallel_jobs=0

# Iterate over image pairs
for i in {1..12}; do
  fixed="../Brains/m${i}.img"

  for j in {1..12}; do
    if [ $j != $i ]; then
      moving="../Brains/m${j}.img"

      output_prefix="outputs/output_${i}_${j}"
      time_file="outputs/time_${i}_${j}.txt"

      # Run the registration command in the background, redirecting output to a time file
      { time -p antsRegistrationSyN.sh -d 3 -f "$fixed" -m "$moving" -o "$output_prefix"; } 2> "$time_file" &

      # Increment the parallel jobs counter
      ((parallel_jobs++))

      # Check if the maximum parallel jobs limit is reached
      if [ $parallel_jobs -eq 12 ]; then
        # Wait for all background jobs to complete
        wait

        # Reset the parallel jobs counter
        parallel_jobs=0
      fi
    fi
  done
done

# Wait for any remaining background jobs to complete
wait
