#!/bin/bash

# Set the value of ITK_GLOBAL_DEFAULT_NUMBER_OF_THREADS to 8
export ITK_GLOBAL_DEFAULT_NUMBER_OF_THREADS=8

# Initialize a counter for parallel jobs
parallel_jobs=0
max_jobs=12

# Iterate over image pairs
for i in {1..18}; do
  ii=$((10#$i))
  fixed="../IBSR_$(printf "%02d" $ii)/IBSR_$(printf "%02d" $ii)_seg_ana.nii.gz"

  for j in {1..18}; do
    if [ $j != $i ]; then
      jj=$((10#$j))
      moving="../IBSR_$(printf "%02d" $jj)/IBSR_$(printf "%02d" $jj)_seg_ana.nii.gz"

      output_prefix="deformed_$(printf "%02d" $ii)_$(printf "%02d" $jj)_seg_ana.nii.gz"
      time_file="infer_time_$(printf "%02d" $ii)_$(printf "%02d" $jj).txt"

      echo antsApplyTransforms -d 3 -i $moving -r $fixed -t  \
	      output_$(printf "%02d" $ii)_$(printf "%02d" $jj)1Warp.nii.gz -t output_$(printf "%02d" $ii)_$(printf "%02d" $jj)0GenericAffine.mat -n GenericLabel -o $output_prefix;
      # Run the registration command in the background, redirecting output to a time file
      { time -p antsApplyTransforms -d 3 -i $moving -r $fixed -t  \
	      output_$(printf "%02d" $ii)_$(printf "%02d" $jj)1Warp.nii.gz -t output_$(printf "%02d" $ii)_$(printf "%02d" $jj)0GenericAffine.mat -n GenericLabel -o $output_prefix; } 2> "$time_file" &

      # Increment the parallel jobs counter
      ((parallel_jobs++))

      # Check if the maximum parallel jobs limit is reached
      if [ $parallel_jobs -eq $max_jobs ]; then
        # Wait for all background jobs to complete
        wait

        # Reset the parallel jobs counter
        parallel_jobs=0
      fi
    fi
  done
done

# Wait for any remaining background jobs to complete
wait

