#!/bin/bash
export ITK_GLOBAL_DEFAULT_NUMBER_OF_THREADS=2
# Initialize a counter for parallel jobs
parallel_jobs=0

# Iterate over image pairs
for i in {1..40}; do
  fixed="../registered_pairs/l${i}_to_l${i}.hdr"   # fixed image is i-->i
  for j in {1..40}; do
    if [ $j != $i ]; then
      moving="../registered_pairs/l${j}_to_l${i}.hdr"  # move j-->i (jth image is warped to ith image)

      # output and time format is same as (fixed, moving)
      output_prefix="outputs/output_${i}_${j}"
      time_file="outputs/time_${i}_${j}.txt"

      # Run the registration command in the background, redirecting output to a time file
      { greedy -d 3 -a -m NCC 2x2x2 -i "$fixed" "$moving" -o "${output_prefix}.mat" -ia-image-centers -n 100x50x10 &&
	time -p greedy -d 3 -m NCC 2x2x2 -i "$fixed" "$moving" -it "${output_prefix}.mat" -o "${output_prefix}_warp.nii.gz" -n 100x50x10;
      } 2> "$time_file" &


      # Increment the parallel jobs counter
      ((parallel_jobs++))

      # Check if the maximum parallel jobs limit is reached
      if [ $parallel_jobs -eq 12 ]; then
        # Wait for all background jobs to complete
        wait
        # Reset the parallel jobs counter
        parallel_jobs=0
      fi
    fi
  done
done

# Wait for any remaining background jobs to complete
wait
