import os
import shutil

print("Starting Tiny ImageNet validation set preparation...")

base_dir = './tiny-imagenet-200'
val_dir = os.path.join(base_dir, 'val')
val_annotations_file = os.path.join(val_dir, 'val_annotations.txt')

val_images_dir = os.path.join(val_dir, 'images')

with open(val_annotations_file, 'r') as f:
    for line in f:
        filename, class_id, _, _, _, _ = line.strip().split('\t')
        
        class_dir = os.path.join(val_dir, class_id)
        if not os.path.exists(class_dir):
            os.makedirs(class_dir)
            
        src_path = os.path.join(val_images_dir, filename)
        dest_path = os.path.join(class_dir, filename)
        
        if os.path.exists(src_path):
            shutil.move(src_path, dest_path)

shutil.rmtree(val_images_dir)
os.remove(val_annotations_file)

print("Preparation complete. The 'val' directory is now structured for ImageFolder.")