# aggregations/registry.py
from .fedavg import FedAvg
from .pfpt_agg import PfptAgg
from .fmoe_agg import FMoEAgg

def load_aggregator(name: str):
    name = (name or "fedavg").lower()
    if name in ("fedavg", "avg"):
        return FedAvg()
    if name == "pfpt_agg":
        return PfptAgg()
    if name == "fmoe_agg":
        return FMoEAgg()
    raise ValueError(f"unknown aggregator: {name}")
