import torch, random, numpy as np
from fl import Server

cfg = {
    "exp_name": "cifar100_lp",
    "seed": 0,

    "model_name": "ova_lp",
    "aggregator_name": "fedavg",

    "data": {
        "dataset": "cifar100",
        "num_clients": 100,
        "partition": {"type": "dirichlet", "alpha": 0.01},
        "label_noise": 0.0,
        "batch_size": 128,
        "cache_root": "./cache"
    },

    "encoder": {
        "type": "mae",          
        "size": "large",
        "from_pretrained": True,
        "tune": False,          
        "precompute_batch_size": 256,
        "save_cache": True
    },

    "train": {
        "num_rounds": 50,
        "local_epochs": 1,
        "lr": 1e-2,
        "weight_decay": 1e-4,
        "active_client_ratio": 1.0,
        "log_every": 1,
        "show_graph": False
    },

    "model": {
        "num_classes": 100,   
        "num_stage1_rounds": 5
    }
}

if __name__ == "__main__":
    seed = int(cfg.get("seed", 0))
    random.seed(seed); np.random.seed(seed); torch.manual_seed(seed)
    if torch.cuda.is_available():
        torch.cuda.manual_seed_all(seed)
        torch.backends.cudnn.deterministic = True
        torch.backends.cudnn.benchmark = False
    Server(cfg, seed).run()
