from .fedavg import FedAvg
from .pfpt_agg import PfptAgg
from .fmoe_agg import FMoEAgg
from .flora_agg import FLoRAAgg

def load_aggregator(name: str):
    name = (name or "fedavg").lower()
    if name in ("fedavg", "avg"):
        return FedAvg()
    if name == "pfpt_agg":
        return PfptAgg()
    if name == "fmoe_agg":
        return FMoEAgg()
    if name == "flora_agg":
        return FLoRAAgg()
        
    raise ValueError(f"unknown aggregator: {name}")