import os, torch

class FeatureCache:
    def __init__(self, cache_dir="./cache"):
        self.cache_dir = cache_dir
        os.makedirs(self.cache_dir, exist_ok=True)

    def _path(self, key: str, split: str, tag: str):
        fname = f"{key}__{split}__{tag}.pt"
        return os.path.join(self.cache_dir, fname)

    def has(self, key: str, split: str, tag: str) -> bool:
        return os.path.exists(self._path(key, split, tag))

    def load(self, key: str, split: str, tag: str):
        obj = torch.load(self._path(key, split, tag), map_location="cpu")
        return obj["features"], obj["targets"]

    def save(self, key: str, split: str, tag: str, features, targets):
        torch.save({"features": features, "targets": targets},
                   self._path(key, split, tag))
