import subprocess
import datetime
import os

# NOTE: This script supports caching of previous results. If we kill the process
# then we should remove the incomplete log for the current run, so that it
# restarts from there.

def main():
    ndim_list = [2]
    rows_list = [128, 256, 512, 1024, 2048, 4096]
    cols_list = [2, 4, 8, 16, 32, 64, 128]
    alg_list = [3, 5] 
    seed_list = [0]

    samples_list = [1028]
    alpha_list = [0.01]
    epsilon_list = [0.1]
    delta_list = [0.01]

    output_path = 'output/kronecker_regression/'

    for ndim in ndim_list:
        for rows in rows_list:
            for cols in cols_list:
                if cols > rows: continue
                for alg in alg_list:
                    for seed in seed_list:
                        for samples in samples_list:
                            for epsilon in epsilon_list:
                                for delta in delta_list:
                                    filename = 'alg{}-ndim{}-rows{}-cols{}-seed{}'.format(alg, ndim, rows, cols, seed)
                                    if alg in [4, 5]:
                                        filename += '-samples{}'.format(samples)
                                    path = output_path + filename + '.txt'

                                    if os.path.exists(path):
                                        print('Already exists:', path)
                                        continue

                                    command = ['python3', 'kronecker_regression_main.py']
                                    command.append('--ndim={}'.format(ndim))
                                    command.append('--rows={}'.format(rows))
                                    command.append('--cols={}'.format(cols))
                                    command.append('--alg={}'.format(alg))
                                    command.append('--seed={}'.format(seed))

                                    command.append('--samples={}'.format(samples))
                                    command.append('--epsilon={}'.format(epsilon))
                                    command.append('--delta={}'.format(delta))

                                    cmd = ' '.join(command)                                    
                                    cmd += ' >> ' + path
                                    print(cmd)
                                    process = subprocess.Popen([cmd], shell=True)
                                    process.wait()

main()

