# Overcoming Domain Limitations in Open-vocabulary Segmentation

This code is based on **fc-clip**.

This repo contains the code for our paper **Overcoming Domain Limitations in Open-vocabulary Segmentation**


> Open-vocabulary segmentation (OVS) has gained attention for its ability to recognize a broader range of classes. However, OVS models show significant performance drops when applied to unseen domains beyond the previous training dataset. Fine-tuning these models on new datasets can improve performance, but often leads to the catastrophic forgetting of previously learned knowledge. To address this issue, we propose a method that allows OVS models to learn information from new domains while preserving prior knowledge. Our approach begins by evaluating the input sample's proximity to multiple domains, using precomputed multivariate normal distributions for each domain. Based on this prediction, we dynamically interpolate between the weights of the pre-trained decoder and the fine-tuned decoders. Extensive experiments demonstrate that this approach allows OVS models to adapt to new domains while maintaining performance on the previous training dataset.


## Installation
See [installation instructions](INSTALL.md).

## Preparing Datasets
See [Preparing Datasets](datasets/README.md).

## Getting Started

This document provides a brief intro of the usage of our method.
Please see [Getting Started with Detectron2](https://github.com/facebookresearch/detectron2/blob/master/GETTING_STARTED.md) for full usage.

### Training & Evaluation in Command Line

We provide a script `train_net.py`, that is made to train all the configs.

To train a model with "train_net.py", first
setup the corresponding datasets following
[datasets/README.md](./datasets/README.md),
then beginning with fine-tuning fc-clip:
```
python train_net.py --num-gpus 1 \
    --config-file \
    configs/cityscapes/custom/fcclip_convnext_large_eval_cityscapes.yaml \
    SOLVER.IMS_PER_BATCH \
    8 \
    SOLVER.BASE_LR \
    0.00005
```
To generate the multivariate normal distribution,
```
python train_net.py --eval-only --num-gpus 1 \
    --config-file \
    configs/cityscapes/custom/fcclip_convnext_large_eval_cityscapes_dwi.yaml \
    MODEL.ENSEMBLE.EXTRACT_PROTOTYPE True \
    MODEL.ENSEMBLE.FINETUNED_MODELS_WEIGHT \
    "['path of the checkpoint for the fine-tuned model']" \
    MODEL.ENSEMBLE.PROTOTYPES_PATH \
    "['output/prototypes/cityscapes_prototype', 'output/prototypes/coco_prototype']" \
    MODEL.ENSEMBLE.PROTOTYPE_NAME gmm \
    DATASETS.TEST \
    "('openvocab_cityscapes_fine_panoptic_train', 'openvocab_coco_2017_train_panoptic_with_sem_seg')" \
    MODEL.ENSEMBLE.TEXT_PROTOTYPE True
```

To evaluate a model's performance, use
```
python train_net.py --eval-only --num-gpus 1 \
    --config-file
    ./configs/cityscapes/custom/fcclip_convnext_large_eval_cityscapes_dwi.yaml
    MODEL.ENSEMBLE.PROTOTYPES_PATH
    "['./output/prototypes/coco_prototype_gmm' ,'./output/prototypes/cityscapes_prototype_gmm',]"
    MODEL.ENSEMBLE.SOFTMAX_TEMPERATURE 0.01
    MODEL.ENSEMBLE.PROTOTYPE_NAME gmm
    MODEL.ENSEMBLE.TEXT_PROTOTYPE True
    MODEL.ENSEMBLE.TEXT_PROTOTYPE_TYPE max
```
For more options, see `python train_net.py -h`.
