#!/bin/bash

function parse_arguments() {
    while [[ $# -gt 0 ]]; do
        case $1 in
            -fs | --first_seed)
                FIRST_SEED=$2
                shift
                shift
                ;;
            -ls | --last_seed)
                LAST_SEED=$2
                shift
                shift
                ;;
            -e | --env)
                ENV=$2
                shift
                shift
                ;;
            -w | --wandb_project)
                WANDB_ARGUMENT="--wandb_project $2"
                shift
                shift
                ;;  
            -n | --n_samples)
                N_SAMPLES=$2
                shift
                shift
                ;; 
            -lr | --learning_rates)
                LEARNING_RATES=$2
                shift
                shift
                ;;   
            -nis | --n_initial_samples)
                N_INITIAL_SAMPLES=$2
                shift
                shift
                ;;
            -utd | --utd)
                UTD=$2
                shift
                shift
                ;;
            -oc | --optimizer_classes)
                OPTIMIZER_CLASSES=$2
                shift
                shift
                ;;
            -naq | --net_archs_qf)
                NET_ARCHS_QF=$2
                shift
                shift
                ;;
            -af | --activation_fns)
                ACTIVATION_FNS=$2
                shift
                shift
                ;;
            -mc | --m_critics)
                M_CRITICS=$2
                shift
                shift
                ;;
            -rt | --random_target_qf)
                RANDOM_TARGET_QF="--random_target_qf"
                shift
                ;;
            -at | --aggregate_target_qf)
                AGGREGATE_TARGET_QF=$2
                shift
                shift
                ;;
            -allp | --all_policy_qf)
                ALL_POLICY_QF="--all_policy_qf"
                shift
                ;;
            -ee | --end_epsilon)
                END_EPSILON=$2
                shift
                shift
                ;;
            -de | --duration_epsilon)
                DURATION_EPSILON=$2
                shift
                shift
                ;;
            -ap | --aggregate_policy_qf)
                AGGREGATE_POLICY_QF=$2
                shift
                shift
                ;;
            -?*)
                printf 'WARN: Unknown option (ignored): %s\n' "$1" >&2
                shift
                ;;
            ?*)
                printf 'WARN: Unknown option (ignored): %s\n' "$1" >&2
                shift
                ;;
        esac
    done
    
    if ( [[ $FIRST_SEED != "" ]] && [[ $LAST_SEED = "" ]] ) || ( [[ $FIRST_SEED == "" ]] && [[ $LAST_SEED != "" ]] )
    then
        echo "you need to specify the first and last seed, use -fs and -ls" >&2
        exit
    fi
}