#!/bin/bash

SHARED_ARGS="--replay_buffer_capacity 1_000_000 --batch_size 32 --update_horizon 1 --gamma 0.99 --horizon 27_000 \
    --n_training_steps_per_epoch 250_000 --update_to_data 4 --n_initial_samples 20_000 --cnn_n_layers_range 1 3 \
    --cnn_n_channels_range 16 64 --cnn_kernel_size_range 2 8 --cnn_stride_range 2 5 --mlp_n_layers_range 0 2 \
    --mlp_n_neurons_range 25 512 --learning_rate_range 6 3"


ADADQN_ARGS="--experiment_name long_tuf_4000_huf_80000_elitism_no_reset_Pong \
    --disable_wandb $SHARED_ARGS --target_update_freq 4000 --n_epochs 40 --n_networks 5 \
    --exploitation_type elitism --epsilon_end 0.01 --epsilon_duration 250_000 \
    --hp_update_frequency 80000"
launch_job/atari/local_adadqn.sh --first_seed 1 --last_seed 1 $ADADQN_ARGS

SEARLDQN_ARGS="--experiment_name tuf_4000_mse_8000_elitism_no_reset_Pong \
    --disable_wandb $SHARED_ARGS --target_update_freq 4000 --n_epochs 40 --n_networks 5 \
    --exploitation_type elitism --min_steps_evaluation 8000"
launch_job/atari/local_searldqn.sh --first_seed 1 --last_seed 1 $SEARLDQN_ARGS

RSDQN_ARGS="--experiment_name hpupe_30_RoadRunner $SHARED_ARGS --target_update_freq 8000 --n_epochs 180 \
    --disable_wandb --epsilon_end 0.01 --epsilon_duration 250_000 --hp_update_per_epoch 30"
launch_job/atari/local_rsdqn.sh --first_seed 1 --last_seed 1 $RSDQN_ARGS

DEHBDQN_ARGS="--experiment_name minnephp_20_maxnephp_40_Pong $SHARED_ARGS --target_update_freq 8000 --n_epochs 180 \
    --disable_wandb --epsilon_end 0.01 --epsilon_duration 250_000 --min_n_epochs_per_hp 20 --max_n_epochs_per_hp 40"
launch_job/atari/local_dehbdqn.sh --first_seed 1 --last_seed 1 $DEHBDQN_ARGS
