#!/bin/bash

SHARED_ARGS="--first_seed 1 --last_seed 1 --features 100 100 \
     --replay_buffer_capacity 10_000 --batch_size 32 --update_horizon 1  \
     --learning_rate 3e-4 --horizon 1_000 --n_epochs 50 --n_training_steps_per_epoch 10_000 \
     --update_to_data 1 --target_update_frequency 200 --n_initial_samples 1_000 --epsilon_duration 1000"

launch_job/lunar_lander/local_adadqn.sh --experiment_name gr_985_995_gv_990 --disable_wandb --gamma_range 0.985 0.995 \
    --gamma_validation 0.990 --n_networks 5 --exploitation_type elitism --hp_update_frequency 10000 $SHARED_ARGS

launch_job/lunar_lander/local_metadqn.sh --experiment_name gi_99_gv_990_mlr_0001 --disable_wandb --gamma_init 0.99 \
    --gamma_validation 0.990 --meta_learning_rate 0.001 $SHARED_ARGS