import os
import sys

import jax

from experiments.base.metadqn import train
from experiments.base.utils import prepare_logs
from slimdqn.environments.lunar_lander import LunarLander
from slimdqn.networks.metadqn import METADQN
from slimdqn.sample_collection.replay_buffer import ReplayBuffer


def run(argvs=sys.argv[1:]):
    env_name, algo_name = os.path.abspath(__file__).split("/")[-2], os.path.abspath(__file__).split("/")[-1][:-3]
    p = prepare_logs(env_name, algo_name, argvs)

    q_key, train_key = jax.random.split(jax.random.PRNGKey(p["seed"]))

    env = LunarLander()
    rb = ReplayBuffer(
        observation_shape=env.observation_shape,
        replay_capacity=p["replay_buffer_capacity"],
        batch_size=p["batch_size"],
        update_horizon=p["update_horizon"],
        gamma=p["gamma_validation"],
    )
    agent = METADQN(
        q_key,
        env.observation_shape[0],
        env.n_actions,
        features=p["features"],
        cnn=False,
        learning_rate=p["learning_rate"],
        meta_learning_rate=p["meta_learning_rate"],
        gamma_init=p["gamma_init"],
        gamma_validation=p["gamma_validation"],
        update_horizon=p["update_horizon"],
        update_to_data=p["update_to_data"],
        target_update_frequency=p["target_update_frequency"],
    )
    train(train_key, p, agent, env, rb)


if __name__ == "__main__":
    run()
