#!/bin/bash

SHARED_ARGS="--features 32 64 64 512 --replay_buffer_capacity 1_000_000 --batch_size 32 \
    --update_horizon 1 --learning_rate 6.25e-5 --horizon 27_000 --n_epochs 40 \
    --n_training_steps_per_epoch 250_000 --update_to_data 4  --target_update_frequency 8000 \
    --n_initial_samples 20_000 --epsilon_duration 250_000 --epsilon_end 0.01"

launch_job/atari/local_adadqn.sh --first_seed 1 --last_seed 1 --experiment_name gr_985_995_gv_990_BattleZone \
    --disable_wandb --gamma_range 0.985 0.995 --gamma_validation 0.99 \
    --n_networks 5 --exploitation_type elitism --hp_update_frequency 80000 $SHARED_ARGS

launch_job/atari/local_metadqn.sh --first_seed 1 --last_seed 1 --experiment_name gi_990_gv_990_mlr_0001_e_BattleZone \
    --disable_wandb --gamma_init 0.99 \
    --gamma_validation 0.99 --meta_learning_rate 0.001 $SHARED_ARGS