#!/bin/bash  

# initialize conda
eval "$(conda shell.bash hook)"

EXP_name='exp1'
IMG_ROOT='/Code/dust3r/datasets/EmbodiedScan/scene0012_00/'
SAVE_ROOT='/Code/dust3r/outputs/' 

# run detection
conda activate glee

cd /Code/GLEE/app/
export CUDA_VISIBLE_DEVICES="0" && python glee_demo.py --img_root $IMG_ROOT --save_root $SAVE_ROOT --exp_name $EXP_name --threshold_select 0.24

conda deactivate

# run segmentation
conda activate sam

cd /Code/segment-anything
export CUDA_VISIBLE_DEVICES="0" && python sam_demo.py --img_root $IMG_ROOT --save_root $SAVE_ROOT --exp_name $EXP_name

conda deactivate

# run dust3r
conda activate dust3r

cd /Code/dust3r
export CUDA_VISIBLE_DEVICES="0" && python dust3r_demo_v2.py --img_root $IMG_ROOT --mask_root $SAVE_ROOT --exp_name $EXP_name