# SURE: Implementation & Benchmark Instructions

This repository contains the implementation code and benchmarking scripts for our secure model repair protocol SURE. This readme file will help you set up dependencies, run benchmarks, and reproduce the results shown in our paper.

---

## Install Dependencies

### 1. emp-toolkit (for the main protocol)

#### Option A: Recommended (automated installation)
```bash
wget https://raw.githubusercontent.com/emp-toolkit/emp-readme/master/scripts/install.py
python3 install.py --deps --tool=update-backend --ot
```

#### Option B: Manual installation

1. Clone and install [emp-tool](https://github.com/emp-toolkit/emp-tool/tree/update-backend) (**make sure to use the `update-backend` branch**) You may need to install its dependencies first following the instructions:
   ```bash
   git clone -b update-backend https://github.com/emp-toolkit/emp-tool.git
   cd emp-tool
   cmake .
   sudo make install
   ```
2. Clone and install [emp-ot](https://github.com/emp-toolkit/emp-ot):
   ```bash
   git clone https://github.com/emp-toolkit/emp-ot.git
   cd emp-ot
   cmake .
   sudo make install
   ```

### 2. MP-SPDZ (for baseline protocol)

If you intend to run or compare with the baseline protocol, you will need to install [MP-SPDZ](https://github.com/data61/MP-SPDZ). Please refer to the [official MP-SPDZ documentation](https://mp-spdz.readthedocs.io/en/latest/index.html) for setup instructions and usage documentation.

---

## Test & Reproduce Results

### Benchmarking the SURE Protocol

#### Option A: Using the Python Benchmark Script

We provide a Python script `exp.py` for intuitive testing and benchmarking. Before running the python script, make sure its dependencies packages are installed.
E.g., 
```bash
    sudo apt-get install python3-matplotlib
```

To reproduce Figure 4 from the paper:

1. Compile the project:
   ```bash
   cmake .
   sudo make
   ```

2. Run the experiment:
   ```bash
   python3 ./exp.py 1 500 1000 1500 2000 2500 3000 --fuzzy 100 --output ./figure.pdf & \
   python3 ./exp.py 2 500 1000 1500 2000 2500 3000 --fuzzy 100
   ```

   - The figure will be saved as `figure.pdf` in the current directory.
   - By default, the experiment will repeat 10 times and plot the average with error bars included. You can change it with the option `--run=1`  
   - Command-line arguments:
      - The first argument is the party ID: `1` or `2`.
      - The following numbers specify database sizes.
      - `--fuzzy` specifies the key length.
      - `--output` sets the output file name.

   Run `python3 ./exp.py --help` for a full list of options.

#### Option B: Manual Testing

You can also directly run the compiled binary.

1. Compile the project:
   ```bash
   cmake .
   sudo make
   ```

2. Run the binary:
   ```bash
   ./bin/test_fix <party_id> <database_size> <key_length>
   ```

   Example:
   ```bash
   ./bin/test_fix 1 500 100 & ./bin/test_fix 2 500 100
   ```

   - Run each party in a separate terminal.
   - To run across two machines, modify the IP address setting in `fix.cpp`.

---

## Benchmarking the Baseline Protocol

After installing MP-SPDZ, compile and run the baseline protocol in the MP-SPDZ root directory. 
   ```bash
   ./Scripts/compile-run.py semi -F 32 <path-to-baseline.mpc>
   ```

   - This runs the protocol in the `baseline.mpc` file.
   - This uses the same underlying 2pc protocol `semi` as the one in our paper.
   - MP-SPDZ will report runtime and communication cost after execution.
   - To change database size or key length, modify the `baseline.mpc` file accordingly.
   - See [here](https://mp-spdz.readthedocs.io/en/latest/readme.html#running-computation) for details on how to compile and execute `.mpc` files.
   - See [here](https://mp-spdz.readthedocs.io/en/latest/Compiler.html) for MP-SPDZ usage documentation (how to modify, extend the .mpc file etc.).

---
