Install required packages using:

```bash
pip install -r requirements.txt
```

> Ensure you are using Python 3.8+ and a working `conda` or `virtualenv` environment.

---

## Usage Guide

### 1. Train Diffusion Model (Offline Behavior Cloning)

```bash
python diffusion_train_behavior.py
```

This trains a conditional diffusion model using offline data to mimic the behavior policy.

---

### 2. In-Support Actions Generation

```bash
python diffusion_support_action.py
```

This generates in-support actions using the learned diffusion model and trains an energy-based function for guiding action selection.

---

### 3. IQL + DARE Training

- **Offline IQL training:**

```bash
python iql_offline.py
```

- **Online fine-tuning with our method:**

```bash
python dare-i.py
```

---

### 4. Cal-QL + DARE Training

- **Offline Cal-QL training:**

```bash
python calql_offline.py
```

- **Online fine-tuning with our method:**

```bash
python dare-c.py
```

---
