# Forge: Foundational Optimization Representation from Graph Embeddings
This repo provides the following and refer to `/forge/train.py` for the main architecture.
* The Forge algorithm `./forge/`
* Training and testing data in `./data/` 
* Trained model artifacts in `./model/`
* Experiments from the paper `./experiments/`

## Structure
```
Forge/
|
|  # Experiments
|_ experiments/                    # contains inference code to run experiments in the paper. 
|___ supervised/
|_____ 1_run_experiments.ipynb
|_____ 2_analyze.ipynb
|_____ pseudo_cut.py
|_____ warm_start.py
|___ unsupervised/
|_____ cluster.ipynb
|
|  # Data
|_ data/                           # train, test intermediate data are stored. See also collector.py and processor.py 
|___ intermediate_files/
|___ log/
|___ temp/
|___ test/
|___ train/
|___ collector.py                  # Collect training labels for fine-tuning
|___ processor.py                  # Process .mps or .lp files into DGL objects.
|
|  # Model Artifacts 
|_ models/                         # contains the pre-trained model outputs
|
|  # Forge Architecture
|_ forge/                          # contains the main GNN architecture based on VQGraph
|___ forge.py                      # This is where our GNN architecture based on VQGraph is defined.
|___ utils.py                      # Helper methods used in `forge.py`
|___ train.py                      # Driver code that runs everything from data processesing, label collection for training, unsupervised pre-training, and supervised fine-tuning.
|___ train.ipynb                   # Interactive version of train.py 
|___ vqgraph/                      # Vector quantization model from [paper](https://arxiv.org/abs/2308.02117). 
```

## SageMaker
SageMaker Environment Setup Instructions: 

    conda create -y -n "gpu" python=3.11.11;
    conda init;
    source .bashrc;
    conda activate gpu;
    conda install -y pytorch==2.4.1 torchvision==0.19.1 torchaudio==2.4.1 pytorch-cuda=12.4 -c pytorch -c nvidia;
    conda install -y -c dglteam/label/th24_cu124 dgl;
    pip install ipykernel igraph networkx torch_geometric matplotlib gurobipy einops category-encoders anytree ogb pyscipopt;
    conda install -y -c conda-forge ecole;
    cp ~/.conda/envs/gpu/lib/libscip.so.8.1 ~/.conda/envs/gpu/lib/libscip.so.8.0;
    python -m ipykernel install --user --name=gpu;
