## Data 

This folder contains a subfolder `intermediate_files` where dictionaries such as mip_to_dgl and mip_to_lp_gap etc. are stored.

- `collector.py` that has code for generating triplets and LP gaps. 
- `processor.py` contains code to read MIP instances, convert them to DGL objects and store a list of DGL objects. 

# Unsupervised Instances: 
These are instances from MIPLIB. The compressed file for these instances can be found at `research/[2025] Forge/data/miplib_instances.zip`

# Supervised Instances: 
These are instances from Distributional MIPLIB (https://sites.google.com/usc.edu/distributional-miplib/home)
The training data can be found under `research/[2025] Forge/data/train.zip` and the test data is at `research/[2025] Forge/data/test.zip`. 

These data files are used for warm start and LP gap training and prediction.
Place both train and test folders in this folder. 

If one does not wish to run the data collection code, the folder `research/[2025] Forge/data/` contains the output of the data collection code that needs to go into the `intermediate_files` folder. These files are: `mips_to_gaps.pkl` and `mips_to_triplets.pkl`.
