# Experiments 

This folder contains files to run experiments for the paper split into `./unsupervised/` and `./supervised/`.  

* The `./unsupervised/` contains the notebook titled `cluster.ipynb` which contains the unsupervised clustering and visualization.
* The `./supervised/` contains two scripts `pseudo_cut.py` and `warm_start.py` that contain the experiment code. They are called using `1_run_experiments.ipynb` and results are analyzed in `2_analyze.ipynb`. 

## Structure 
```
unsupervised/
    - cluster.ipynb: GNN trained unsupervised to inspect clusters and visualize MIP instances 
supervised/
    - pseudo_cut.py: Code to run Gurobi with and without predicted lp cuts 
    - warm_start.py: Code to run Gurobi with and without predicted warm starts 
    - 1_run_experiments.ipynb` takes the `pseudo_cut.py` and `warm_start.py` files and runs them as sub-processes. 
    - 2_analyze.ipynb: To analyze the output of running `pseudo_cut.py` and `warm_start.py`
```