col = {[0,0,.8],[.8,0,0],[0,.8,0]};
linest = {'-.','--',':'};
mark = {'+','x','o'};

hf = figure(1);
hf1 = hf;
clf
ax = gca;

hold on
for i = 1:3

    if i==1
        p0 = 4; t = 3e-5;
        datafile = sprintf('data/exp1_p4.mat');
    elseif i==2
        p0 = 7; t = 3e-5;
        datafile = sprintf('data/exp1_p7.mat');
    else
        p0 = 12; t = 2e-5;
        datafile = sprintf('data/exp1_p12.mat');
    end
    load(datafile,'Gap','ErrX','p');

    % Computations
    I = (p>=p0-4) & (p<=p0+3);
    x = double(p(I)-p0);
    y = mean(Gap(I,:)<t,2)*100;
    % y = mean(ErrX<.5,2)*100;

    % Draw plots
    xx = x(1):1/4:x(end);
    yy = pchip(x,y,xx);
    hPlot = plot(xx,yy);
    % hPlot2 = plot(x,y);

    % plot properties
    set(hPlot,...
        'LineStyle',linest{i},...
        'LineWidth',2.8,...
        'Color', col{i},...
        'Marker', mark{i},...,
        'MarkerSize',16,...,
        'MarkerFaceColor',col{i},...
        'MarkerEdgeColor',.9*col{i},...,
        'MarkerIndices',1:4:(length(xx)))
    if i==3
        set(hPlot,'MarkerSize',6);
    end

end
hLine = xline(-.5);
set(hLine,...
    'LineStyle',':',...
    'Color',[.6,.6,.6],...
    'LineWidth',2.5)
hold off

% scale
xlim([-4.5,3.5])
ylim([-5,105])
hXLabel = xlabel('Rank of the factor matrix (p)');
hYLabel = ylabel('Experiments solved (%)');
xticklabels({'r-4','r-3','r-2','r-1','r','r+1','r+2','r+3'});

hTitle = title('n = 50,   m = \tau(r)');

% legend
hLegend = legend('r=4','r=7','r=12');
set(hLegend,...
    'Position',[0.72 0.24 0.1 0.08],...
    'LineWidth',2.0);

% fonts
set(ax,'FontName', 'Helvetica', 'FontSize', 22);
set(hLegend, 'FontSize', 22);
set([hXLabel, hYLabel], 'FontName', 'AvantGarde', 'FontSize', 24);
set( hTitle, ...
    'FontName', 'TeX Gyre Bonum Math',...
    'FontSize', 24, ...
    'FontWeight' , 'normal');

% axis properties
set(ax, ...
  'Box'         , 'on'     , ...
  'TickDir'     , 'in'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'Xtick'       , -4:3, ...
  'YTick'       , 0:20:100, ...
  'YColor'      , [.3 .3 .3], ...
  'Layer'       ,'top', ....
  'LineWidth'   , 2.5         );

% figure properties
pause(.1)
set(hf,...,
    'Color', [1,1,1],...
    'Renderer', 'painters',...
    'Units', 'inches',...
    'PaperPositionMode', 'auto')
set(hf,'WindowStyle','normal','InnerPosition', [10 4 10 7]);

% print('exp1.png','-dpng','-r300')