function [Gap,ErrX] = read_iters(fin_regexp,fout,I,J)

[n,p,SS,XX,YY0] = read_in(fin_regexp,I,J);
yy = read_out(fout,I,J);

Gap = cell(I,J);
ErrX = cell(I,J);

for i = 1:I
    for j = 1:J
        Y0 = YY0{i,j};
        X0 = XX{i,j};
        S0 = SS{i,j};
        y = yy{i,j}; %include 0-th iteration
        y = [reshape(Y0,1,[]);y];
        T = size(y,1);
        gap = zeros(T,1);
        errX = zeros(T,1);
        for t = 1:T
            if i==2
                1;
            end
            Yt = reshape(y(t,:),n,p);
            Xt = Yt * Yt';
            gap(t) = norm(Xt*S0);
            errX(t) = norm(Xt-X0,'fro');
        end
        Gap{i,j} = gap;
        ErrX{i,j} = errX;
    end
end

if I*J==1
    Gap = Gap{1};
    ErrX = ErrX{1};
end


function [n,p,SS,XX,YY] = read_in(fin_regex,I,J)

SS = cell(I,J);
XX = cell(I,J);
YY = cell(I,J);
for i = 1:I
    for j = 1:J
        fin = sprintf(fin_regex,i,j);
        load(fin,'S0','X0','Y0');
        if isstruct(S0)
            S0 = S0.data;
        end
        if norm(S0)<1e-20
            error('solver did not return dual');
        end
        SS{i,j} = S0;
        XX{i,j} = X0;
        YY{i,j} = Y0;
    end
end
n = size(Y0,1);
p = size(Y0,2);


function Yvec = read_out(fout,I,J)

% find chunks
lines = splitlines(fileread(fout));
K = length(lines);
chunks = [];
for k = 1:K
    if startsWith(lines{k},'####')
        chunks = [chunks, k];
    end
end
if isempty(chunks)
    chunks = 1;
end
if length(chunks)~=I*J
    error('chunks do not match');
end
chunks = [chunks, K+1];

% reach chunks
Yvec = cell(I,J);
l = 0;
for i=1:I
    for j=1:J
        l = l+1;
        k1 = chunks(l);
        k2 = chunks(l+1)-1;
        y = read_chunk(lines(k1:k2));
        Yvec{i,j} = y;
    end
end


function y = read_chunk(lines)

K = length(lines);
y = [];
for k = 1:K
    l = lines{k};
    if contains(l,'xcur')
        i0 = regexp(l,'=');
        str = l(i0+1:end);
        y = [y; str2num(str)];
    end
end