export CUDA_VISIBLE_DEVICES=0

model_name=CGTFra
seq_len=96
pred_len=96
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path ETTm2.csv \
  --model_id ETTm2_96_96 \
  --model $model_name \
  --data ETTm2 \
  --features M \
  --seq_len 96 \
  --pred_len 96 \
  --enc_in 7 \
  --dec_in 7 \
  --c_out 7 \
  --des 'Exp' \
  --batch_size 32 \
  --learning_rate 0.0005 \
  --nodedim 10 \
  --d_model 96 \
  --e_layers 1 \
  --itr 1 >logs/ETTm2/$model_name'_'ETTm2_$seq_len'_'$pred_len.log

pred_len=192
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path ETTm2.csv \
  --model_id ETTm2_96_192 \
  --model $model_name \
  --data ETTm2 \
  --features M \
  --seq_len 96 \
  --pred_len 192 \
  --enc_in 7 \
  --dec_in 7 \
  --c_out 7 \
  --des 'Exp' \
  --batch_size 64 \
  --learning_rate 0.0005 \
  --nodedim 12 \
  --d_model 192 \
  --e_layers 1 \
  --itr 1 >logs/ETTm2/$model_name'_'ETTm2_$seq_len'_'$pred_len.log

pred_len=336
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path ETTm2.csv \
  --model_id ETTm2_96_336 \
  --model $model_name \
  --data ETTm2 \
  --features M \
  --seq_len 96 \
  --pred_len 336 \
  --enc_in 7 \
  --dec_in 7 \
  --c_out 7 \
  --des 'Exp' \
  --batch_size 16 \
  --learning_rate 0.001 \
  --nodedim 10 \
  --d_model 96 \
  --e_layers 2 \
  --itr 1 >logs/ETTm2/$model_name'_'ETTm2_$seq_len'_'$pred_len.log

pred_len=720
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path ETTm2.csv \
  --model_id ETTm2_96_720 \
  --model $model_name \
  --data ETTm2 \
  --features M \
  --seq_len 96 \
  --pred_len 720 \
  --enc_in 7 \
  --dec_in 7 \
  --c_out 7 \
  --des 'Exp' \
  --batch_size 16 \
  --learning_rate 0.001 \
  --nodedim 10 \
  --d_model 336 \
  --e_layers 2 \
  --itr 1 >logs/ETTm2/$model_name'_'ETTm2_$seq_len'_'$pred_len.log