export CUDA_VISIBLE_DEVICES=0

model_name=CGTFra
seq_len=96
pred_len=96
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path exchange_rate.csv \
  --model_id Exchange_96_96 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len 96 \
  --pred_len 96 \
  --enc_in 8 \
  --dec_in 8 \
  --c_out 8 \
  --des 'Exp' \
  --batch_size 64 \
  --learning_rate 0.0008 \
  --nodedim 10 \
  --d_model 96 \
  --e_layers 1 \
  --lradj 'type4' \
  --itr 1 >logs/Exchange/$model_name'_'Exchange_$seq_len'_'$pred_len.log

pred_len=192
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path exchange_rate.csv \
  --model_id Exchange_96_192 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len 96 \
  --pred_len 192 \
  --enc_in 8 \
  --dec_in 8 \
  --c_out 8 \
  --des 'Exp' \
  --batch_size 128 \
  --learning_rate 0.002 \
  --nodedim 10 \
  --d_model 128 \
  --e_layers 1 \
  --lradj 'type4' \
  --itr 1 >logs/Exchange/$model_name'_'Exchange_$seq_len'_'$pred_len.log

pred_len=336
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path exchange_rate.csv \
  --model_id Exchange_96_336 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len 96 \
  --pred_len 336 \
  --enc_in 8 \
  --dec_in 8 \
  --c_out 8 \
  --des 'Exp' \
  --batch_size 64 \
  --learning_rate 0.001 \
  --nodedim 12 \
  --d_model 128 \
  --e_layers 2 \
  --lradj 'type4' \
  --train_epochs 4 \
  --itr 1 >logs/Exchange/$model_name'_'Exchange_$seq_len'_'$pred_len.log

pred_len=720
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path exchange_rate.csv \
  --model_id Exchange_96_720 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len 96 \
  --pred_len 720 \
  --enc_in 8 \
  --dec_in 8 \
  --c_out 8 \
  --des 'Exp' \
  --batch_size 64 \
  --learning_rate 0.001 \
  --nodedim 12 \
  --d_model 128 \
  --e_layers 3 \
  --lradj 'type4' \
  --train_epochs 2 \
  --itr 1 >logs/Exchange/$model_name'_'Exchange_$seq_len'_'$pred_len.log
