export CUDA_VISIBLE_DEVICES=0

model_name=CGTFra
seq_len=96
pred_len=96
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path traffic.csv \
  --model_id traffic_96_96 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len 96 \
  --pred_len 96 \
  --enc_in 862 \
  --dec_in 862 \
  --c_out 862 \
  --des 'Exp' \
  --batch_size 16 \
  --learning_rate 0.0008 \
  --nodedim 10 \
  --d_model 512 \
  --e_layers 4 \
  --lradj 'type4' \
  --itr 1 >logs/traffic/$model_name'_'traffic_$seq_len'_'$pred_len.log

pred_len=192
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path traffic.csv \
  --model_id traffic_96_192 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len 96 \
  --pred_len 192 \
  --enc_in 862 \
  --dec_in 862 \
  --c_out 862 \
  --des 'Exp' \
  --batch_size 16 \
  --learning_rate 0.0008 \
  --nodedim 64 \
  --d_model 512 \
  --e_layers 4 \
  --lradj 'type4' \
  --itr 1 >logs/traffic/$model_name'_'traffic_$seq_len'_'$pred_len.log

pred_len=336
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path traffic.csv \
  --model_id traffic_96_336 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len 96 \
  --pred_len 336 \
  --enc_in 862 \
  --dec_in 862 \
  --c_out 862 \
  --des 'Exp' \
  --batch_size 16 \
  --learning_rate 0.0008 \
  --nodedim 10 \
  --d_model 336 \
  --e_layers 4 \
  --lradj 'type4' \
  --itr 1 >logs/traffic/$model_name'_'traffic_$seq_len'_'$pred_len.log

pred_len=720
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path traffic.csv \
  --model_id traffic_96_720 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len 96 \
  --pred_len 720 \
  --enc_in 862 \
  --dec_in 862 \
  --c_out 862 \
  --des 'Exp' \
  --batch_size 16 \
  --learning_rate 0.0008 \
  --nodedim 10 \
  --d_model 512 \
  --e_layers 4 \
  --lradj 'type4' \
  --Lambda 0.3 \
  --itr 1 >logs/traffic/$model_name'_'traffic_$seq_len'_'$pred_len.log
