import os
import torch
from model import Transformer, Informer, Reformer, Flowformer, Flashformer, \
    iReformer, iReformer_DGL, \
    iFlowformer, iFlowformer_DGL, \
    iFlashformer, iFlashformer_DGL, \
    iInformer, iInformer_DGL, iInformer_DGL_loss, \
    iTransformer, iTransformer_FMR, iTransformer_DGL, iTransformer_DGL_loss, \
    VCformer, VCformer_FMR, VCformer_DGL, VCformer_DGL_loss, \
    CASA, CASA_FMR


class Exp_Basic(object):
    def __init__(self, args):
        self.args = args
        self.model_dict = {
            'Transformer': Transformer,
            'Informer': Informer,
            'Reformer': Reformer,
            'Flowformer': Flowformer,
            'Flashformer': Flashformer,
            'iInformer': iInformer,
            'iInformer_DGL': iInformer_DGL,
            'iInformer_DGL_loss': iInformer_DGL_loss,
            'iReformer': iReformer,
            'iReformer_DGL': iReformer_DGL,
            'iFlowformer': iFlowformer,
            'iFlowformer_DGL': iFlowformer_DGL,
            'iFlashformer': iFlashformer,
            'iFlashformer_DGL': iFlashformer_DGL,
            'iTransformer': iTransformer,
            'iTransformer_FMR': iTransformer_FMR,
            'iTransformer_DGL': iTransformer_DGL,
            'iTransformer_DGL_loss': iTransformer_DGL_loss,
            'VCformer': VCformer,
            'VCformer_DGL': VCformer_DGL,
            'VCformer_FMR': VCformer_FMR,
            'VCformer_DGL_loss': VCformer_DGL_loss,
            'CASA': CASA,
            'CASA_FMR': CASA_FMR,
        }
        self.device = self._acquire_device()
        self.model = self._build_model().to(self.device)

    def _build_model(self):
        raise NotImplementedError
        return None

    def _acquire_device(self):
        if self.args.use_gpu:
            os.environ["CUDA_VISIBLE_DEVICES"] = str(
                self.args.gpu) if not self.args.use_multi_gpu else self.args.devices
            device = torch.device('cuda:{}'.format(self.args.gpu))
            print('Use GPU: cuda:{}'.format(self.args.gpu))
        else:
            device = torch.device('cpu')
            print('Use CPU')
        return device

    def _get_data(self):
        pass

    def vali(self):
        pass

    def train(self):
        pass

    def test(self):
        pass
