export CUDA_VISIBLE_DEVICES=0

model_name=CGTFra
seq_len=96
pred_len=96
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path solar_AL.txt \
  --model_id solar_96_96 \
  --model $model_name \
  --data Solar \
  --features M \
  --seq_len 96 \
  --pred_len 96 \
  --enc_in 137 \
  --dec_in 137 \
  --c_out 137 \
  --des 'Exp' \
  --batch_size 32 \
  --learning_rate 0.0006 \
  --nodedim 64 \
  --d_model 96 \
  --e_layers 2 \
  --lradj 'type4' \
  --itr 1 >logs/solar/$model_name'_'solar_$seq_len'_'$pred_len.log

pred_len=192
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path solar_AL.txt \
  --model_id solar_96_192 \
  --model $model_name \
  --data Solar \
  --features M \
  --seq_len 96 \
  --pred_len 192 \
  --enc_in 137 \
  --dec_in 137 \
  --c_out 137 \
  --des 'Exp' \
  --batch_size 32 \
  --learning_rate 0.001 \
  --nodedim 64 \
  --d_model 96 \
  --e_layers 2 \
  --lradj 'type4' \
  --itr 1 >logs/solar/$model_name'_'solar_$seq_len'_'$pred_len.log

pred_len=336
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path solar_AL.txt \
  --model_id solar_96_336 \
  --model $model_name \
  --data Solar \
  --features M \
  --seq_len 96 \
  --pred_len 336 \
  --enc_in 137 \
  --dec_in 137 \
  --c_out 137 \
  --des 'Exp' \
  --batch_size 32 \
  --learning_rate 0.001 \
  --nodedim 64 \
  --d_model 192 \
  --e_layers 2 \
  --lradj 'type4' \
  --itr 1 >logs/solar/$model_name'_'solar_$seq_len'_'$pred_len.log

pred_len=720
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path solar_AL.txt \
  --model_id solar_96_720 \
  --model $model_name \
  --data Solar \
  --features M \
  --seq_len 96 \
  --pred_len 720 \
  --enc_in 137 \
  --dec_in 137 \
  --c_out 137 \
  --des 'Exp' \
  --batch_size 32 \
  --learning_rate 0.001 \
  --nodedim 64 \
  --d_model 256 \
  --e_layers 2 \
  --lradj 'type4' \
  --itr 1 >logs/solar/$model_name'_'solar_$seq_len'_'$pred_len.log
