export CUDA_VISIBLE_DEVICES=0

model_name=CGTFra
seq_len=96
pred_len=96
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path weather.csv \
  --model_id weather_96_96 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len 96 \
  --pred_len 96 \
  --enc_in 21 \
  --dec_in 21 \
  --c_out 21 \
  --des 'Exp' \
  --batch_size 32 \
  --learning_rate 0.005 \
  --nodedim 10 \
  --d_model 96 \
  --e_layers 1 \
  --lradj 'type1' \
  --itr 1 >logs/weather/$model_name'_'weather_$seq_len'_'$pred_len.log

pred_len=192
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path weather.csv \
  --model_id weather_96_192 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len 96 \
  --pred_len 192 \
  --enc_in 21 \
  --dec_in 21 \
  --c_out 21 \
  --des 'Exp' \
  --batch_size 32 \
  --learning_rate 0.0008 \
  --nodedim 10 \
  --d_model 192 \
  --e_layers 1 \
  --lradj 'type1' \
  --itr 1 >logs/weather/$model_name'_'weather_$seq_len'_'$pred_len.log

pred_len=336
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path weather.csv \
  --model_id weather_96_336 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len 96 \
  --pred_len 336 \
  --enc_in 21 \
  --dec_in 21 \
  --c_out 21 \
  --des 'Exp' \
  --batch_size 32 \
  --learning_rate 0.003 \
  --nodedim 10 \
  --d_model 192 \
  --e_layers 1 \
  --lradj 'type1' \
  --itr 1 >logs/weather/$model_name'_'weather_$seq_len'_'$pred_len.log

pred_len=720
python -u run.py \
  --is_training 1 \
  --root_path ./data/ \
  --data_path weather.csv \
  --model_id weather_96_720 \
  --model $model_name \
  --data custom \
  --features M \
  --seq_len 96 \
  --pred_len 720 \
  --enc_in 21 \
  --dec_in 21 \
  --c_out 21 \
  --des 'Exp' \
  --batch_size 32 \
  --learning_rate 0.003 \
  --nodedim 10 \
  --d_model 192 \
  --e_layers 1 \
  --lradj 'type1' \
  --itr 1 >logs/weather/$model_name'_'weather_$seq_len'_'$pred_len.log
