#  CGTFra: Graph Transformer Framework for Consistent Inter-series Dependency Modeling for Multivariate Time Series Forecasting
Under Review in ICLR 2026

## Prerequisites

Ensure you are using Python >= 3.8 and install the necessary dependencies in the requirements.txt

## Prepare Datastes

Begin by downloading the required datasets. All datasets are conveniently available at [URL](https://drive.google.com/file/d/1l51QsKvQPcqILT3DwfjCgx8Dsg2rpjot/view?usp=drive_link). We thank all iTransformer authors who provide the dataset URL. Create a separate folder named `./data` and neatly organize all the csv files as shown below:
```
data
└── PEMS
└── electricity.csv
└── ETTh1.csv
└── ETTh2.csv
└── ETTm1.csv
└── ETTm2.csv
└── exchange_rate.csv
└── solar_AL.txt
└── traffic.csv
└── weather.csv
```

## Training

All scripts are located in `./scripts`. For instance, to train or test a model using the ETTh1 dataset with an input length of 96, simply run:

```shell
bash ./scripts/ICLR/ETT/ETTh1.sh
```

After training:

- Your trained model will be safely stored in `./checkpoints`.
- Numerical results in .npy format can be found in `./results`.
- A comprehensive summary of quantitative metrics is accessible in `./result.txt`.

## Verifying the effectiveness of FMR, DGL and CAL, Reproducing the results in Table 2 (Table 12), Table 3 (Table 13) and Table 5 (Table 14)

DUET:
Download the dataset from the well pre-processed datasets from their provided [Google Drive](https://drive.google.com/file/d/1vgpOmAygokoUt235piWKUjfwao6KwLv7/view) or [Baidu Drive](https://pan.baidu.com/s/1ycq7ufOD2eFOjDkjr0BfSg?pwd=bpry). Then place the downloaded data under the folder ./DUET-main/dataset.
- Run the shell scripts from DUET-main/scripts/multivariate_forecast/
```shell
# run the original DUET
bash ./DUET-main/scripts/multivariate_forecast/DUET.sh
# run the DUET integrated our DGL
bash ./DUET-main/scripts/multivariate_forecast/DUET_DGL.sh
# run the DUET integrated our DGL and CAL
bash ./DUET-main/scripts/multivariate_forecast/DUET_DGL_CAL.sh
```

iTansformer, VCformer, CASA and other variate Transformers: The datasets and storage paths are kept consistent with those used in our CGTFra (see the description above).
- Run the shell scripts from ./FMR_DGL_CAL/scripts (we provide some examples like following command)
```shell
# run CASA integrated our FMR
bash ./FMR_DGL_CAL/scripts/CASA_scripts/ECL_script/CASA.sh 
bash ./FMR_DGL_CAL/scripts/CASA_scripts/ECL_script/CASA_FMR.sh 
# run iTransformer integrated our FMR, DGL and CAL
bash ./FMR_DGL_CAL/scripts/iTransformer/ECL/iTransformer.sh
# run VCformer integrated our FMR, DGL and CAL
bash ./FMR_DGL_CAL/scripts/VCformer_scripts/ECL.sh
bash ./FMR_DGL_CAL/scripts/VCformer_scripts/ECL_DGL.sh
bash ./FMR_DGL_CAL/scripts/VCformer_scripts/ECL_DGL_CAL.sh
# run other variate Transformers integrated our DGL and CAL
bash ./FMR_DGL_CAL/scripts/VariateTransformers/ECL/iFlashTransformer.sh
bash ./FMR_DGL_CAL/scripts/VariateTransformers/ECL/iFlashTransformer_DGL.sh
bash ./FMR_DGL_CAL/scripts/VariateTransformers/ECL/iFlowformer.sh
bash ./FMR_DGL_CAL/scripts/VariateTransformers/ECL/iFlowformer_DGL.sh
bash ./FMR_DGL_CAL/scripts/VariateTransformers/ECL/iInformer.sh
bash ./FMR_DGL_CAL/scripts/VariateTransformers/ECL/iInformer_DGL.sh
bash ./FMR_DGL_CAL/scripts/VariateTransformers/ECL/iInformer_DGL_CAL.sh
bash ./FMR_DGL_CAL/scripts/VariateTransformers/ECL/iReformer.sh
bash ./FMR_DGL_CAL/scripts/VariateTransformers/ECL/iReformer_DGL.sh
bash ./FMR_DGL_CAL/scripts/VariateTransformers/ECL/iTransformer.sh
bash ./FMR_DGL_CAL/scripts/VariateTransformers/ECL/iTransformer_DGL.sh
bash ./FMR_DGL_CAL/scripts/VariateTransformers/ECL/iTransformer_DGL_CAL.sh
```

## Acknowledgement
Special thanks to the following repositories for their invaluable code and datasets:

- [DUET](https://github.com/decisionintelligence/DUET)
- [VCformer](https://github.com/CSyyn/VCformer)
- [iTransformer](https://github.com/thuml/iTransformer)
- [CASA](https://github.com/lmh9507/CASA)
- Reformer (https://github.com/lucidrains/reformer-pytorch)
- Informer (https://github.com/zhouhaoyi/Informer2020)
- FlashAttention (https://github.com/shreyansh26/FlashAttention-PyTorch)
- Autoformer (https://github.com/thuml/Autoformer)

