import torch
import torch.nn as nn
import torch.nn.functional as F
from layers.KTD import KTDlayer
from layers.VCformer_Enc import Encoder, EncoderLayer
from layers.SelfAttention_Family_VCformer import VarCorAttention, VarCorAttentionLayer
from layers.Embed import DataEmbedding_inverted, FrequencyMaskResample
import numpy as np


class Model(nn.Module):
    def __init__(self, configs):
        super(Model, self).__init__()
        # self.task_name = configs.task_name
        self.seq_len = configs.seq_len
        self.pred_len = configs.pred_len
        self.output_attention = configs.output_attention
        # Embedding

        # self.enc_embedding = DataEmbedding_inverted(configs.seq_len, configs.d_model, configs.embed, configs.freq,
        #                                             configs.dropout)  # replace
        self.fmr = FrequencyMaskResample(num_variables=configs.enc_in, sequence_length=self.seq_len,
                                                    out_length=configs.d_model,
                                                    mask_activation='softplus')
        # Encoder

        self.encoder = Encoder(
            [
                EncoderLayer(
                    VarCorAttentionLayer(
                        VarCorAttention(configs, False, configs.factor, attention_dropout=configs.dropout,
                                        output_attention=configs.output_attention), configs.d_model, configs.n_heads),
                    KTDlayer(configs, configs.d_model, configs.snap_size,
                             configs.proj_dim, configs.hidden_dim, configs.hidden_layers),
                    configs.d_model,
                    configs.d_ff,
                    dropout=configs.dropout,
                    activation=configs.activation
                ) for l in range(configs.e_layers)
            ],
            norm_layer=torch.nn.LayerNorm(configs.d_model)
        )

        # Decoder

        self.projection = nn.Linear(
            configs.d_model, configs.pred_len, bias=True)

    def forecast(self, x_enc, x_mark_enc, x_dec, x_mark_dec):
        # Normalization from Non-stationary Transformer
        means = x_enc.mean(1, keepdim=True).detach()
        x_enc = x_enc - means
        stdev = torch.sqrt(
            torch.var(x_enc, dim=1, keepdim=True, unbiased=False) + 1e-5)
        x_enc /= stdev

        _, _, N = x_enc.shape

        # Embedding
        # enc_out = self.enc_embedding(x_enc, x_mark_enc)  # replace
        enc_out = self.fmr(x_enc.permute(0,2,1))  # FMR

        enc_out, attns = self.encoder(enc_out, attn_mask=None)
        # reshape enc_out[B,D,T] -> dec_out[B,T,D]
        dec_out = self.projection(enc_out).permute(0, 2, 1)[:, :, :N]
        # De-Normalization from Non-stationary Transformer
        dec_out = dec_out * \
            (stdev[:, 0, :].unsqueeze(1).repeat(1, self.pred_len, 1))
        dec_out = dec_out + \
            (means[:, 0, :].unsqueeze(1).repeat(1, self.pred_len, 1))
        return dec_out, attns

    def forward(self, x_enc, x_mark_enc, x_dec, x_mark_dec, mask=None):

        dec_out, attns = self.forecast(
            x_enc, x_mark_enc, x_dec, x_mark_dec)
        return dec_out[:, -self.pred_len:, :]  # [B, L, D]
