#!/bin/bash
#SBATCH --job-name=my_job           # Name of your job
#SBATCH --output=./out/output_%j.log      # Output log file (%j is job ID)
#SBATCH --error=./error/error_%j.log        # Error log file
#SBATCH --time=$TIMEOUT             # Time limit (HH:MM:SS)
#SBATCH $PARTITION        # Partition/queue name
#SBATCH --ntasks=1                  # Number of tasks
#SBATCH --cpus-per-task=$CPU           # Number of CPU cores per task
#SBATCH --mem=200G                    # Memory per node

#SBATCH --mail-type=END,FAIL        # When to email you (optional)



# Navigate to your working directory
cd <your_hpc_dir>/exp_control
source activate <your env>
export OMP_NUM_THREADS=4


# Execute your command
python -m sf_examples.dmlab.train_hippo2025 $CMD

