#!/usr/bin/env bash
set -e

# make sure log directory exists
OUTPUT_DIR="output_dir/datasets/Case_2/shell_logs"
mkdir -p "$OUTPUT_DIR"




export CUDA_VISIBLE_DEVICES=3

echo "Starting job 0 on GPU 0"
python dataset_generation.py @Case2_generation_arguments.txt --sample_seed 0 --job_id 0 > "$OUTPUT_DIR/Case2_0.log" 2>&1 &

echo "Starting job 1 on GPU 0"
python dataset_generation.py @Case2_generation_arguments.txt --sample_seed 1 --job_id 1 > "$OUTPUT_DIR/Case2_1.log" 2>&1 &

echo "Starting job 2 on GPU 0"
python dataset_generation.py @Case2_generation_arguments.txt --sample_seed 2 --job_id 2 > "$OUTPUT_DIR/Case2_2.log" 2>&1 &

echo "Starting job 3 on GPU 0"
python dataset_generation.py @Case2_generation_arguments.txt --sample_seed 3 --job_id 3 > "$OUTPUT_DIR/Case2_3.log" 2>&1 &

echo "Starting job 4 on GPU 0"
python dataset_generation.py @Case2_generation_arguments.txt --sample_seed 4 --job_id 4 > "$OUTPUT_DIR/Case2_4.log" 2>&1 &




export CUDA_VISIBLE_DEVICES=4

echo "Starting job 5 on GPU 1"
python dataset_generation.py @Case2_generation_arguments.txt --sample_seed 5 --job_id 5 > "$OUTPUT_DIR/Case2_5.log" 2>&1 &

echo "Starting job 6 on GPU 1"
python dataset_generation.py @Case2_generation_arguments.txt --sample_seed 6 --job_id 6 > "$OUTPUT_DIR/Case2_6.log" 2>&1 &

echo "Starting job 7 on GPU 1"
python dataset_generation.py @Case2_generation_arguments.txt --sample_seed 7 --job_id 7 > "$OUTPUT_DIR/Case2_7.log" 2>&1 &

echo "Starting job 8 on GPU 1"
python dataset_generation.py @Case2_generation_arguments.txt --sample_seed 8 --job_id 8 > "$OUTPUT_DIR/Case2_8.log" 2>&1 &

echo "Starting job 9 on GPU 1"
python dataset_generation.py @Case2_generation_arguments.txt --sample_seed 9 --job_id 9 > "$OUTPUT_DIR/Case2_9.log" 2>&1 &



# make sure log directory exists
OUTPUT_DIR="output_dir/datasets/Case_1/shell_logs"
mkdir -p "$OUTPUT_DIR"



export CUDA_VISIBLE_DEVICES=5

echo "Starting job 0 on GPU 0"
python dataset_generation.py @Case1_generation_arguments.txt --sample_seed 0 --job_id 0 > "$OUTPUT_DIR/Case1_0.log" 2>&1 &

echo "Starting job 1 on GPU 0"
python dataset_generation.py @Case1_generation_arguments.txt --sample_seed 1 --job_id 1 > "$OUTPUT_DIR/Case1_1.log" 2>&1 &

echo "Starting job 2 on GPU 0"
python dataset_generation.py @Case1_generation_arguments.txt --sample_seed 2 --job_id 2 > "$OUTPUT_DIR/Case1_2.log" 2>&1 &

echo "Starting job 3 on GPU 0"
python dataset_generation.py @Case1_generation_arguments.txt --sample_seed 3 --job_id 3 > "$OUTPUT_DIR/Case1_3.log" 2>&1 &

echo "Starting job 4 on GPU 0"
python dataset_generation.py @Case1_generation_arguments.txt --sample_seed 4 --job_id 4 > "$OUTPUT_DIR/Case1_4.log" 2>&1 &




export CUDA_VISIBLE_DEVICES=6

echo "Starting job 5 on GPU 1"
python dataset_generation.py @Case1_generation_arguments.txt --sample_seed 5 --job_id 5 > "$OUTPUT_DIR/Case1_5.log" 2>&1 &

echo "Starting job 6 on GPU 1"
python dataset_generation.py @Case1_generation_arguments.txt --sample_seed 6 --job_id 6 > "$OUTPUT_DIR/Case1_6.log" 2>&1 &

echo "Starting job 7 on GPU 1"
python dataset_generation.py @Case1_generation_arguments.txt --sample_seed 7 --job_id 7 > "$OUTPUT_DIR/Case1_7.log" 2>&1 &

echo "Starting job 8 on GPU 1"
python dataset_generation.py @Case1_generation_arguments.txt --sample_seed 8 --job_id 8 > "$OUTPUT_DIR/Case1_8.log" 2>&1 &

echo "Starting job 9 on GPU 1"
python dataset_generation.py @Case1_generation_arguments.txt --sample_seed 9 --job_id 9 > "$OUTPUT_DIR/Case1_9.log" 2>&1 &




echo "All requested jobs launched in background."
echo "Monitor with: tail -f $OUTPUT_DIR/Case1_<ID>.log"
