# Stability of QNN simulation codes

### Install Paddle Quantum

The experiment is carried in Paddle Quantum version `2.4.0`. To run the codes in this repository, you need to install Paddle Quantum first.

```bash
pip install paddle-quantum==2.4.0
```

### Overview of Repository Structure
This repository contains a series of scripts configured to test the performance of Quantum Neural Networks across various datasets and training conditions. Each script is prefixed with a code indicating the target dataset:

* BC: Scripts for running classifiers on the Breast Cancer dataset.
* FMNIST: Scripts for running classifiers on the Fashion MNIST dataset.
* MNIST: Scripts for running classifiers on the MNIST dataset.

#### Script Description
* `fix_L`: Contains code for evaluating QNN performance while varying the number of trainable parameters and this primarily involves fixing the number of data reuploading layers.

* `vary_layers`: Includes code for assessing how variations in the number of data reuploading layers impact QNN performance.

* `num_samples`: Provides scripts for testing QNN performance across different numbers of training samples, allowing for an analysis of how training sample size influences model effectiveness.

* `vary_learning_rate`: Contains code for experimenting with different learning rates to find the optimal setting for QNN training.
