# Representation Topology Divergence 

## Running in the docker:

1. ./docker_build.sh
2. change the name in docker_run.sh for convenience
3. ./docker_run.sh

in the docker:

4. conda activate py37
5. bash start_jupyter.sh
6. connect to the jupyter server at port 8896

For execution without docker install: conda, ripserplusplus, pytorch, torchvision.

## Usage:

1. Calculate R-Cross-Barcodes and RTD for two random point clouds:

```python
import numpy as np
import barcodes
np.random.seed(7)

P = np.random.rand(100, 10)
Q = np.random.rand(100, 10)

barc = barcodes.calc_embed_dist(P, Q, pdist_device = 'cuda:0')
print('RTD', barcodes.h1sum(barc))
```

2. Run Clusters.ipynb and Rings.ipynb to reproduce experiments with clusters and rings from the manuscript.