import numpy as np
import argparse
import json
import os

CH = np.random.choice

def init_command(dset):
    with open('command.json', mode='r') as infile:
        commands = json.load(infile)
    return commands[dset]

def main(args=None):

    COMMAND = init_command(args.dset)

    with open(args.exp_filepath, mode='r') as infile:
        exp = json.load(infile)

    command = COMMAND + " " + "--meta "
    command += "--n_task {} ".format(exp['n_task'])
    command += "--n_support {} ".format(exp['n_support'])
    command += "--k_support {} ".format(exp['k_support'])
    command += "--n_query {} ".format(exp['n_query'])
    command += "--k_query {} ".format(exp['k_query'])
    command += "--n_subset {} ".format(exp['n_subset'])
    command += "--alpha {} ".format(exp['alpha'])
    command += "--gamma {} ".format(exp['gamma'])
    command += "--n_meta_syn {} ".format(exp['n_meta_syn'])
    command += "--meta_weight {} ".format(exp['meta_weight'])
    command += "--meta_loss_type {} ".format(exp['meta_loss_type'])
    if args.finetune:
        command += " --finetune "
         
    #os.system(command + ' --validation') # validation run
    os.system(command) # test run
        

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--dset', type=str, choices=['CUB', 'AWA', 'SUN', 'FLO'])
    parser.add_argument('--finetune', action='store_true', default=False, help='use finetuned features')
    parser.add_argument('--exp_filepath', type=str)
    args = parser.parse_args()
    main(args)
