'''Clean train'''
import argparse
from framework.adv import Engine
from framework.config import get_arch

if __name__ == '__main__':

  parser = argparse.ArgumentParser(description='Clean Train')
  parser.add_argument('--lr', default=0.1, type=float, help='learning rate')
  parser.add_argument('--resume_ckpt', default='none', type=str,
                      help='Checkpoint path')
  parser.add_argument('--pathdir', default='none', type=str)
  parser.add_argument('--dataset', default='cifar10', type=str)
  parser.add_argument('--arch', default='resnet32', type=str)
  args = parser.parse_args()

  pathdir = None if args.pathdir == 'none' else args.pathdir
  resume_checkpoint = None if args.resume_ckpt == 'none' else args.resume_ckpt
  engine = Engine(dataset=args.dataset,
                  basic_net=lambda: get_arch(args.arch),
                  lr=args.lr,
                  resume_checkpoint=resume_checkpoint,
                  attack='none',
                  pathdir=pathdir,
                  test_first=0 if resume_checkpoint else 1)
  engine.start()