# Transferred Discrepancy: Quantifying the Difference Between Representations

This is the code to replicate the results of our paper.

## Install dependencies

```python
python >= 3.60
conda install numpy pandas
conda install pytorch torchvision cudatoolkit=10.0 -c pytorch
```

## Example

We will show how to train a ResNet32 model on Cifar-5 and obtain the TD value on Cifar-10.

One need to change the data root in framework/config.py to the folder containing the dataset.

```python
python main.py cifar10 --arch resnet32 --train_task sclass 
		--test_task class --train_label 5 --test_label 10
		--repre_root .... --repre_folder ....
```

Here, 'sclass' stands for Cifar-5 and 'class' stands for Cifar-10. Train_label and test_label require the number of categories in the corresponding task.

Then load the data into td.py, it will output the td value.

